/*
  Developed by LoveTech.io, Copyright 2016
  Released Under the MOT License - Free to Use and Distribute w/ Above Copyright - See MOT_license.txt for full terms (Not for War)
*/

$(document).ready(function() {
	$(document).on("click", '.addUpBtn', function() {
		$(this).data("ArrayTable").newRow({})
	});
	$(document).on("click", '.addAltBtn', function() {
		$(this).data("ArrayTable").newRow({"alt":true})
	});
	$(document).on("change", '.radioChangerEl', function() {
		var rowUI = $(this).closest(".arraytablerow").attr("ui");
		var arrayTableObj = $(this).closest(".arraytable").data("ArrayTable");
		if(arrayTableObj != null && arrayTableObj.listening == true) {
			if(arrayTableObj != null && arrayTableObj.updateRow != null && $(this).attr("prop") != null && $(this).val() != null) {
				arrayTableObj.updateRow(rowUI, $(this).attr("prop"), $(this).val());
			}
		}
	});
	$(document).on("change", '.checkChangerEl', function() {
		var rowUI = $(this).closest(".arraytablerow").attr("ui");
		var arrayTableObj = $(this).closest(".arraytable").data("ArrayTable");
		if(arrayTableObj != null && arrayTableObj.listening == true) {
			if(arrayTableObj != null && arrayTableObj.updateRow != null && $(this).attr("prop") != null && $(this).val() != null) {
				arrayTableObj.updateRow(rowUI, $(this).attr("prop"), $(this).is(":checked"));
			}
		}
	});
	$(document).on("keyup contextmenu input paste change", '.keyChangerEl', function() {
		var rowUI = $(this).closest(".arraytablerow").attr("ui");
		var arrayTableObj = $(this).closest(".arraytable").data("ArrayTable");
		if(arrayTableObj != null && arrayTableObj.listening == true) {
			if(arrayTableObj != null && arrayTableObj.updateRow != null && $(this).attr("prop") != null && $(this).val() != null) {
				arrayTableObj.updateRow(rowUI, $(this).attr("prop"), $(this).val());
			}
		}
	});
	$(document).on("change", '.changerEl', function() {
		var rowUI = $(this).closest(".arraytablerow").attr("ui");
		var arrayTableObj = $(this).closest(".arraytable").data("ArrayTable");
		if(arrayTableObj != null && arrayTableObj.listening == true) {
			if(arrayTableObj != null && arrayTableObj.updateRow != null && $(this).attr("prop") != null && $(this).val() != null) {
				var newVal = $(this).val();
				arrayTableObj.updateRow(rowUI, $(this).attr("prop"), newVal);
			}
		}
	});
	$(document).on("click", '.delRowBtn', function() {
		var rowEl = $(this).closest(".arraytablerow");
		var rowUI = $(this).closest(".arraytablerow").attr("ui");
		var arrayTableObj = $(this).closest(".arraytable").data("ArrayTable");
		if(arrayTableObj != null && arrayTableObj.listening == true) {
			if(confirm("Are you sure that you want to delete this entry?")) {
				arrayTableObj.deleteRow(rowUI);
			}
		}
		
	});
	String.prototype.replaceAll = function(str1, str2, ignore) {
		return this.replace(new RegExp(str1.replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g,"\\$&"),(ignore?"gi":"g")),(typeof(str2)=="string")?str2.replace(/\$/g,"$$$$"):str2);
	}
	$(document).on("click", ".editBtn", function() {
        var refEl = $(this).closest("tr");
		/*if(refEl.next("tr").hasClass("rowApnd")) {
			refEl = refEl.add(refEl.next("tr"));
		}*/
        if($(this).hasClass("tdover")) {
            refEl = $(this).closest("td");
        }
        if($(this).hasClass("tbodyGrp")) {
            refEl = $(this).closest("tbody");
        }
        if($(this).closest("table").length > 0 && $(this).closest("table").hasClass("tbodyGrp")) {
            refEl = $(this).closest("tbody");
        }
        //tdover
        refEl.find(".display").hide();
        refEl.find(".edit").show();
        refEl.find(".checkChangerEl").prop("disabled", false);
        refEl.find(".checkChangeTrigger").prop("disabled", false);
        $(this).parent().find(".saveBtn").show();
        $(this).hide();
    });
    $(document).on("click", ".saveBtn", function() {
        var refEl = $(this).closest("tr");
		/*if(refEl.next("tr").hasClass("rowApnd")) {
			refEl = refEl.add(refEl.next("tr"));
		}*/
        if($(this).hasClass("tdover")) {
            refEl = $(this).closest("td");
        }
        if($(this).hasClass("arTabRowOver")) {
            refEl = $(this).closest(".arraytablerow");
        }
        if($(this).closest("table").length > 0 && $(this).closest("table").hasClass("tbodyGrp")) {
            refEl = $(this).closest("tbody");
        }
        refEl.find(".display").show();
        refEl.find(".edit").hide();
        refEl.find(".checkChangeTrigger").prop("disabled", true);
        refEl.find(".checkChangerEl").prop("disabled", true);
        $(this).parent().find(".editBtn").show();
        $(this).hide();
    });

});

function getSelectedOptionString(editEl) {
	var strs = [];
	editEl.find("option:selected").each(function() {
		strs.push($(this).text());
	});
	return strs.join(", ")
}
(function($, doc, win) {
  "use strict";
 
 function ArrayTableViewObject(el, opts, callback) {
    this.$el  = $(el);
    this.opts = opts;
    this.callback = callback;
	this.listening = false;
	this.curState = "display";
	this.saveDelays = {};
	this.saveRate = 250;
	this.loc = "";
	if(opts.loc != null) {
		this.loc = opts.loc;
	}
	if(opts.saveRate != null) {
		this.saveRate = opts.saveRate;
	}
	this.stateFuncts = {
		"edit":function(objEditAd, el) {
			el.find(".display").hide();
			el.find(".edit").show();
			el.find(".checkChangerEl").removeAttr("disabled");
		},
		"display":function(objEditAd, el) {
			el.find(".display").show();
			el.find(".edit").hide();
			el.find(".checkChangerEl").attr("disabled","disabled");
		}
	};
	if(this.opts.states != null) {
		for (var key in this.opts.states) {
			if (this.opts.states.hasOwnProperty(key)) {
				this.stateFuncts[key] = this.opts.states[key];
			}
		}
	}
	if(opts.startState != null) {
		this.curState = opts.startState;
	}
	if(this.stateFuncts[this.curState] != null) {
		this.stateFuncts[this.curState](this, $(el));
	}
	if(opts.addBtn != null) {
		opts.addBtn.data("ArrayTable", this);
		opts.addBtn.addClass("addUpBtn");
	}
	if(opts.altRowAddBtn != null) {
		opts.altRowAddBtn.data("ArrayTable", this);
		opts.altRowAddBtn.addClass("addAltBtn");
	}
	if(this.opts.addable == false) {
		if(opts.addBtn != null) {
			opts.addBtn.hide()
		}
		if(opts.altRowAddBtn != null) {
			opts.altRowAddBtn.hide()
		}
	} else {
		if(opts.addBtn != null) {
			opts.addBtn.show()
		}
		if(opts.altRowAddBtn != null) {
			opts.altRowAddBtn.show()
		}
	}
	
	if(this.opts.dataSrc == null) {
		if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
			this.opts.dataSrc = [];
		} else {
			this.opts.dataSrc = {};
		}
	}
	this.rerenderRows();
	if(this.opts.sortable != null && this.opts.sortable == true) {
		//Default behavior for non-associative
		var stopFunction = function() {
			var newUIOrder = [];
			$(this).data("ArrayTable").$el.find(".arraytablerow").each(function() {
				newUIOrder.push($(this).attr("ui"));
			});
			$(this).data("ArrayTable").updateOrder(newUIOrder);
		};
		/*if(this.opts.associativeArray != null && this.opts.associativeArray == true) {
			stopFunction = function() {
				var newUIOrder = [];
				$(this).data("ArrayTable").$el.find(".arraytablerow").each(function() {
					newUIOrder.push($(this).attr("ui"));
				});
				$(this).data("ArrayTable").updateOrderAssc(newUIOrder);
			};
		}*/
		var sortOpts = {
			start: function() {
				
			},
			forceHelperSize: true,
			helper: "clone",
			forcePlaceholderSize: true,
			placeholder:'test',
			distance: 8,
			stop: stopFunction
		};
		if(this.opts.sortHandleClass != null) {
			sortOpts.handle = "." + this.opts.sortHandleClass;
		}
		sortOpts.cancel += "input,textarea,button,select,option,.chosen-container,.keyChangerEl,.input-field";
		if(this.opts.cancel != null) {
			sortOpts.cancel += "," + this.opts.cancel;
		}
		this.$el.sortable(sortOpts);
		this.$el.bind("click mousedown", function(ev) {
			if(!$(this).is(":focus")) {
				$(ev.target).focus();
			}
		})

	}
	if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
		
	} 
	this.listening = true;
  }
  
 /* ArrayTableViewObject.prototype.getDataAsscNested = function() {
		var baseData = this.opts.dataSrc;
		if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
			for(var a = 0; a < baseData.length; a++) {
				for(var key in this.opts.mapping) {
					if(this.opts.mapping.hasOwnProperty(key)) {
						if(this.opts.mapping[key]["type"] != null && this.opts.mapping[key]["type"] == "subArrayTable") {
							var subArrayTable = this.$el.find(".subArrayTable[keyprop='" + a + "_" + key + "']").data("ArrayTable");
							if(subArrayTable != null) {
								baseData[a][key] = subArrayTable.getDataAsscNested();
							}
						}
					}
				}
			}
		} else {
			for(var a in baseData) {
				if(baseData.hasOwnProperty(a)) {
					for(var key in this.opts.mapping) {
						if(this.opts.mapping.hasOwnProperty(key)) {
							if(this.opts.mapping[key]["type"] != null && this.opts.mapping[key]["type"] == "subArrayTable") {
								var subArrayTable = this.$el.find(".subArrayTable[keyprop='" + a + "_" + key + "']").data("ArrayTable");
								if(subArrayTable != null) {
									baseData[a][key] = subArrayTable.getDataAsscNested();
								}
							}
						}
					}
				}
			}
		}
		return baseData;
  };*/
  ArrayTableViewObject.prototype.stopListening = function(newState) {
	this.listening = false;
  };
  ArrayTableViewObject.prototype.changeState = function(newState) {
	if(this.curState != newState) {
		this.curState = newState;
		if(this.stateFuncts[this.curState] != null) {
			this.stateFuncts[this.curState](this, $(el));
		}
	}
  }
  ArrayTableViewObject.prototype.updateOrder = function(newOrder) {
	var oldJson = JSON.stringify(this.opts.dataSrc);
	if(this.opts.associativeArray != null && this.opts.associativeArray == true) {
		//Clear all oi values
		for(var key in this.opts.dataSrc) {
			if(this.opts.dataSrc.hasOwnProperty(key)) {
				if(this.opts.dataSrc[key]["oi"] != null) {
					delete this.opts.dataSrc[key]["oi"];
				}
			}
		}
		for(var i = 0; i < newOrder.length; i++) {
			for(var key in this.opts.dataSrc) {
				if(this.opts.dataSrc.hasOwnProperty(key)) {
					if(this.opts.dataSrc[key]["ui"] == newOrder[i]) {
						this.opts.dataSrc[key]["oi"] = i;
						break;
					}
				}
			}
		}
	} else {
		this.opts.dataSrc.sort(function(a, b) {
			return newOrder.indexOf(a.ui) - newOrder.indexOf(b.ui);
		});
	}

	if(oldJson != JSON.stringify(this.opts.dataSrc)) {
		if(this.opts.afterReorder != null) {
			this.opts.afterReorder(this, newOrder);
		}
		this.renumberRows();
	}
  }
  
  ArrayTableViewObject.prototype.queueSaveRequest = function(data, rowEl) {
	if(this.saveDelays[data[this.opts.guidKey]] != null) {
		window.clearTimeout(this.saveDelays[data[this.opts.guidKey]]);
	}
	var edArrayTab = this;
	if(edArrayTab.opts.rowSave != null) {
		this.saveDelays[data[this.opts.guidKey]] = window.setTimeout(function() {
			edArrayTab.opts.rowSave(edArrayTab, rowEl, data);
		}, this.saveRate);
	}
  }
  
  ArrayTableViewObject.prototype.rerenderRows = function() {
	this.$el.html("");

	var flatData = [];
	
	if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
		flatData = this.opts.dataSrc;
	} else {
		//Flatten
		for(var key in this.opts.dataSrc) {
			if(this.opts.dataSrc.hasOwnProperty(key) && key != "-1") {
				flatData.push(this.opts.dataSrc[key]);
				flatData[flatData.length - 1]["key"] = key;
			}
		}
		//Perform Sort
		if(this.opts.associativeSort != null && this.opts.associativeSort == "oi") {
			flatData.sort(function(a, b) {
				if(a.oi != null) {
					if(b.oi != null) {
						return a.oi - b.oi;
					} else {
						return -1;
					}
				} else if(b.oi != null) {
					return 1;
				}
				var textA = a.key.toUpperCase();
				var textB = b.key.toUpperCase();
				return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
			});
		} else if(this.opts.associativeSort != null && this.opts.associativeSort == "numeric") {
			//Not sure how useful this is:
			flatData.sort(function(a, b) {
				return a.key - b.key;
			});
		} else if(this.opts.associativeSort != null && this.opts.associativeSort == "alpha") {
			flatData.sort(function(a, b) {
				var textA = a.key.toUpperCase();
				var textB = b.key.toUpperCase();
				return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
			});
		}
	}
	if(flatData.length == 0) {
		this.$el.html(this.opts.noneHtml);
	} else {
		for(var i = 0; i < flatData.length; i++) {
			var rowHtml = this.opts.rowHtml;
			if(flatData[i]["alt"] == true) {
				rowHtml = this.opts.altRowHtml;
			}
			var curData = {};
			if(flatData[i].ui == null){
				flatData[i].ui = this.randomString(4);
			}
			rowHtml = rowHtml.replaceAll("[[ui]]", flatData[i].ui);
			for (var prop in this.opts.mapping) {
				if (this.opts.mapping.hasOwnProperty(prop)) {
					//this.opts.mapping[prop]
					if(this.opts.mapping[prop]["type"] == null || this.opts.mapping[prop]["type"] != "subArrayTable") {
						var replc = "";
						if(flatData[i][prop] != null) {
							replc = flatData[i][prop];
						}
						curData[prop] = replc;
						rowHtml = rowHtml.replaceAll("[[" + prop + "]]", replc);
					} else if(this.opts.mapping[prop]["type"] == "subArrayTable") {
						curData[prop] = flatData[i][prop];
						//curData[prop] = this.opts.dataSrc[flatData[i]["key"]][prop];
					}
				}
			}
			var countOffset = 0;
			if(this.opts.countOffset != null) {
				countOffset = this.opts.countOffset;
			}
			if(this.opts.letter == true) {
				rowHtml = rowHtml.replaceAll("[[let]]", String.fromCharCode('a'.charCodeAt(0)+countOffset+i)); 
			}
			if(this.opts.number == true) {
				rowHtml = rowHtml.replaceAll("[[num]]", 1+countOffset+i); 
			}
			this.$el.append(rowHtml);




			if((1+countOffset+i) % 2 == 1) {
				this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]').addClass("oddRow");
			}
			if(this.opts.beforeDataFill != null) {
				this.opts.beforeDataFill(this, this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]'), flatData[i]);
			}
			if(this.opts.guid != null && this.opts.guid > 0 && this.opts.guidKey != null) {
				this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]').attr("guid",flatData[i][this.opts.guidKey]);
			}
			this.$el.find("." + this.opts.deleteClass).not(".delRowBtn").addClass("delRowBtn");
			if(flatData[i]["del"] == false) {
				this.$el.find("." + this.opts.deleteClass).hide();
			}

			if(this.opts.beforeOrigRow != null) {
				this.opts.beforeOrigRow(this, this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]'), flatData[i]);
			}
			if(this.opts.beforeRow != null) {
				this.opts.beforeRow(this, this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]'), flatData[i]);
			}
			for (var prop in this.opts.mapping) {
				if (this.opts.mapping.hasOwnProperty(prop)) {
					if(this.opts.mapping[prop]["type"] != null && this.opts.mapping[prop]["type"] == "subArrayTable") {
						var opts = owl.deepCopy(this.opts.mapping[prop]["opts"]);
						var elem = this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]').find('.' + this.opts.mapping[prop]["el"]);
						if(opts.addBtnSeek != null) {
							opts["addBtn"] = opts.addBtnSeek(elem);
						}
						//var rowData = this.getRowData(flatData[i].ui);
						 //opts["dataSrc"] = rowData[prop];
						 opts["dataSrc"] = this.opts.dataSrc[flatData[i]["key"]][prop];
						 opts["subArrayTable"] = true;
						elem.ArrayTableView(opts);
						elem.addClass("subArrayTable").attr("keyprop", flatData[i]["key"] + "_" + prop);
					} else {
						var editEl = this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]').find('.' + this.opts.mapping[prop]["el"]);
						var dispEl = this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]').find('.' + this.opts.mapping[prop]["disp"]);
						dispEl.attr("prop", prop).addClass("fieldDisp");
						if(editEl.is("input")) {
							if(editEl.is("input[type='checkbox']")) {
								editEl.attr("prop", prop);
								editEl.data("obEdit", this);
								if(flatData[i][prop] == true) {
									editEl.attr("checked", "checked").change();
									dispEl.html("Yes");
								} else {
									editEl.removeAttr("checked").change();
									dispEl.html("No");
								}	
								editEl.addClass("checkChangerEl");
							}  else if(editEl.hasClass("dateTimeIn") || editEl.hasClass("datetimein")) {
								editEl.attr("prop", prop);
								if(flatData[i][prop] != null) {
									editEl.val(flatData[i][prop]).change();
									dispEl.html(fDate(flatData[i][prop]));
								}
								editEl.addClass("keyChangerEl");
								editEl.addClass("changerEl");
							} else if(editEl.is("input[type='radio']")) {
								editEl.attr("prop", prop);
								var selVal = flatData[i][prop];
								editEl.each(function() {
									if($(this).attr("value") == selVal) {
										$(this).prop("checked", true);
									} else {
										$(this).prop("checked", false);
									}
								});
								editEl.addClass("radioChangerEl");
							} else {
								editEl.attr("prop", prop);
								if(flatData[i][prop] != null) {
									editEl.val(flatData[i][prop]).keyup();
								}
								editEl.addClass("keyChangerEl");
								editEl.addClass("changerEl");
							}
							
						} else if(editEl.is("textarea")) {
							editEl.attr("prop", prop);
							if(flatData[i][prop] != null) {
								editEl.val(flatData[i][prop]).keyup();
								dispEl.html(flatData[i][prop]);
							} else {
								dispEl.html("");
							}
							editEl.addClass("keyChangerEl");
							editEl.addClass("changerEl");
						} else if(editEl.is("select")) {
							editEl.attr("prop", prop);
							if(flatData[i][prop] != null) {
								editEl.val(flatData[i][prop]).change();
							} else {
								editEl.val("-1").change();
							}
							if(editEl.data("chosen") != null) {
								editEl.trigger("chosen:updated");
							}
							if(flatData[i][prop] != null) {
								dispEl.html(getSelectedOptionString(editEl));
							} else {
								dispEl.html("");
							}
							editEl.addClass("changerEl");
						}
					}
				}
			}
			if(this.opts.deleteClass != null) {
				if(this.opts.canDelete == false) {
					this.$el.find("." + this.opts.deleteClass).hide()
				}
				this.$el.find("." + this.opts.deleteClass).not(".delRowBtn").addClass("delRowBtn");
			}
			var rowEl = this.$el.find('.arraytablerow[ui="' + flatData[i].ui + '"]');
			if(this.opts.processRow != null) {
				this.opts.processRow(this, rowEl, flatData[i]);
			}
			
			if(this.opts.applyChildState == true && flatData[i].state != null) {
				if(this.stateFuncts[flatData[i].state] != null) {
					this.stateFuncts[flatData[i].state](this, rowEl, flatData[i]);
				}
			} else {
				if(this.stateFuncts[this.curState] != null) {
					this.stateFuncts[this.curState](this, rowEl);
				}
			}
			if(this.opts.afterOrigRow != null) {
				this.opts.afterOrigRow(this, rowEl, flatData[i]);
			}

			if(this.opts.afterRow != null) {
				this.opts.afterRow(this, rowEl, flatData[i]);
			}
			if(this.opts.rowChanged != null) {
				this.opts.rowChanged(this, rowEl,flatData[i]);
			}
		}
	}
	if(this.opts.onRerender != null) {
		this.opts.onRerender(this, this.$el);
	}
  }
  ArrayTableViewObject.prototype.renumberRows = function() {
	var count = 0;
	var countOffset = 0;
	if(this.opts.countOffset != null) {
		countOffset = this.opts.countOffset;
	}
	if(this.opts.number == true) {
		this.$el.find(".nHol").each(function() {
			$(this).html(1+countOffset+count);
			if(1+countOffset+count % 2 == 1) {
				$(this).closest(".arraytablerow").addClass("oddRow");
			} else {
				$(this).closest(".arraytablerow").removeClass("oddRow");
			}
			count++;
		});
	}
	count = 0;
	if(this.opts.letter == true) {
		this.$el.find(".lHol").each(function() {
			$(this).html(String.fromCharCode('a'.charCodeAt(0)+countOffset+count));
		});
	}
	if(this.opts.afterRenumber != null) {
		this.opts.afterRenumber(this, this.$el);
	}
  }
  ArrayTableViewObject.prototype.deleteRow = function(ui) {
	if(this.opts.canDelete != false) {
		this.$el.find('.arraytablerow[ui="' + ui + '"]').remove();
		var ind = -1;
		if(this.opts.dataSrc != null) {
			if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
				for(var i = 0; i < this.opts.dataSrc.length; i++) {
					if(this.opts.dataSrc[i]["ui"] == ui) {
						ind = i;
					}
				}
				if(ind != -1) {
					this.opts.dataSrc.splice(ind, 1);
					if(this.opts.afterDelete != null) {
						this.opts.afterDelete(this, ui);
					}
				}
				if(this.opts.dataSrc.length == 0) {
					if(this.opts.noneHtml != null) {
						this.$el.html(this.opts.noneHtml);
					} else {
						this.$el.html("");
					}
				}
			} else {
				for(var key in this.opts.dataSrc) {
					if(this.opts.dataSrc.hasOwnProperty(key)) {
						if(this.opts.dataSrc[key]["ui"] == ui) {
							delete this.opts.dataSrc[key];
							if(this.opts.afterDelete != null) {
								this.opts.afterDelete(this, ui);
							}
							break;
						}
					}
				}
				if($.isEmptyObject(this.opts.dataSrc)) {
					if(this.opts.noneHtml != null) {
						this.$el.html(this.opts.noneHtml);
					} else {
						this.$el.html("");
					}
				}
			}
		}
		this.renumberRows();
		//saveAllOpenCases();
	}
  }
  ArrayTableViewObject.prototype.updateRow = function(ui, prop, newVal, params) {
	if(params == null) {
		params = {};
	}
	if(newVal != null && (params.negOneAllowed == true || newVal != "-1")) {

		if(this.opts.dataSrc != null) {
			if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
				for(var i = 0; i < this.opts.dataSrc.length; i++) {
					if(this.opts.dataSrc[i]["ui"] == ui) {
						this.opts.dataSrc[i][prop] = newVal;
						var editEl = $('.arraytablerow[ui="' + ui + '"]').find("." + this.opts.mapping[prop]["el"]);
						if(editEl.length > 0 && editEl.is("select")) {
							var selOpt = editEl.find("option:selected");
							var selTxts = [];
							for(var j = 0; j < selOpt.length; j++) {
								selTxts.push($(selOpt[j]).html());
							}
							this.$el.find('.arraytablerow[ui="' + ui + '"] .fieldDisp[prop="' + prop + '"]').html(selTxts.join(", "));
						} else {
							this.$el.find('.arraytablerow[ui="' + ui + '"] .fieldDisp[prop="' + prop + '"]').html(newVal);
						}
						if(this.opts.rowChanged != null) {
							this.opts.rowChanged(this, this.$el.find('.arraytablerow[ui="' + ui + '"]'), this.opts.dataSrc[i]);

						}
						if(prop == "state" && this.opts.applyChildState == true) {
							if(this.stateFuncts[newVal] != null) {
								this.stateFuncts[newVal](this, this.$el.find('.arraytablerow[ui="' + ui + '"]'), this.opts.dataSrc[i]);
							}
						}
						if(!this.opts.rowSave != null) {
							this.queueSaveRequest(this.opts.dataSrc[i], this.$el.find('.arraytablerow[ui="' + ui + '"]'));
						}
					}
				}
			} else {
				for(var key in this.opts.dataSrc) {
					if(this.opts.dataSrc.hasOwnProperty(key)) {
						if(this.opts.dataSrc[key]["ui"] == ui) {
							this.opts.dataSrc[key][prop] = newVal;
							var editEl = $('.arraytablerow[ui="' + ui + '"]').find("." + this.opts.mapping[prop]["el"]);
							if(editEl.length > 0 && editEl.is("select")) {
								var selOpt = editEl.find("option:selected");
								var selTxts = [];
								for(var j = 0; j < selOpt.length; j++) {
									selTxts.push($(selOpt[j]).html());
								}
								this.$el.find('.arraytablerow[ui="' + ui + '"] .fieldDisp[prop="' + prop + '"]').html(selTxts.join(", "));
							} else {
								this.$el.find('.arraytablerow[ui="' + ui + '"] .fieldDisp[prop="' + prop + '"]').html(newVal);
							}
							if(this.opts.rowChanged != null) {
								this.opts.rowChanged(this, this.$el.find('.arraytablerow[ui="' + ui + '"]'), this.opts.dataSrc[key]);

							}
							if(prop == "state" && this.opts.applyChildState == true) {
								if(this.stateFuncts[newVal] != null) {
									this.stateFuncts[newVal](this, this.$el.find('.arraytablerow[ui="' + ui + '"]'), this.opts.dataSrc[key]);
								}
							}
							if(!this.opts.rowSave != null) {
								this.queueSaveRequest(this.opts.dataSrc[key], this.$el.find('.arraytablerow[ui="' + ui + '"]'));
							}
						}
					}
				}
			}
		} else {
			if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
				this.opts.dataSrc = [];
			} else {
				this.opts.dataSrc = {};
			}
		}
	}
	//saveAllOpenCases();
  };
  ArrayTableViewObject.prototype.randomString = function(length) {
	var result = '';
	var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	for (var i = length; i > 0; --i) result += chars[Math.round(Math.random() * (chars.length - 1))];
	return result;
}
  
  ArrayTableViewObject.prototype.getRowData = function(ui) {
	if(this.opts.dataSrc != null) {
		if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
			for(var i = 0; i < this.opts.dataSrc.length; i++) {
				if(this.opts.dataSrc[i]["ui"] == ui) {
					return this.opts.dataSrc[i];
				}
			}
		} else {
			for(var key in this.opts.dataSrc) {
				if(this.opts.dataSrc.hasOwnProperty(key)) {
					if(this.opts.dataSrc[key]["ui"] == ui) {
						return this.opts.dataSrc[key];
					}
				}
			}
		}
	}
	return -1;
  };
  ArrayTableViewObject.prototype.newRow = function(options) {
	if(this.opts.dataSrc == null) {
		if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
			this.opts.dataSrc = [];
		} else {
			this.opts.dataSrc = {};
		}
	}
	if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
		if(this.opts.dataSrc.length == 0) {
			this.$el.html("");
		}
	} else {
		if($.isEmptyObject(this.opts.dataSrc)) {
			this.$el.html("");
		}
	}
	var newAddObj = {};
	if(this.opts.rowDefaultVar != null) {
		newAddObj = owl.deepCopy(this.opts.rowDefaultVar);
		//newAddObj = jQuery.extend({}, this.opts.rowDefaultVar);
	}
	if(options.startVals != null) {
		newAddObj = jQuery.extend(newAddObj, options.startVals);
	}
	var rowHtml = this.opts.rowHtml;
	if(options.alt != null && options.alt == true) {
		rowHtml = this.opts.altRowHtml;
		newAddObj["alt"] = true;
	}
	newAddObj["ui"] = this.randomString(4);
	rowHtml = rowHtml.replaceAll("[[ui]]", newAddObj.ui);
	if(this.opts.rowDefaultVar != null) {
		for (var prop in this.opts.rowDefaultVar) {
			if (this.opts.rowDefaultVar.hasOwnProperty(prop)) {
				rowHtml = rowHtml.replaceAll("[[" + prop + "]]", this.opts.rowDefaultVar[prop]);
			}
		}
	}
	if(this.opts.mapping != "flat") {
		for (var prop in this.opts.mapping) {
			if (this.opts.mapping.hasOwnProperty(prop)) {
				if(newAddObj[prop] == null) {
					newAddObj[prop] = "";
				}
				rowHtml = rowHtml.replaceAll("[[" + prop + "]]", newAddObj[prop]);
			}
		}
	}
	var countOffset = 0;
	if(this.opts.countOffset != null) {
		countOffset = this.opts.countOffset;
	}
	if(this.opts.letter == true) {
		rowHtml = rowHtml.replaceAll("[[let]]", String.fromCharCode('a'.charCodeAt(0)+countOffset+this.$el.children(".arraytablerow").length));
	}
	if(this.opts.number == true) {
		rowHtml = rowHtml.replaceAll("[[num]]", 1+countOffset+this.$el.children(".arraytablerow").length); 
	}
	//Guid row if specified
	if(this.opts.guid != null && this.opts.guid > 0 && this.opts.guidKey != null) {
		newAddObj[this.opts.guidKey] = this.randomString(this.opts.guid);
	}

	var addIndex = -1;
	if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
		this.opts.dataSrc.push(newAddObj);
		addIndex = this.opts.dataSrc.length - 1;
	} else {
		addIndex = this.randomString(5);
		this.opts.dataSrc[addIndex] = newAddObj;
	}
	this.$el.append(rowHtml);
	
	var rowEl = this.$el.find('.arraytablerow[ui="' + newAddObj.ui + '"]');
	
	if(this.opts.guid != null && this.opts.guid > 0 && this.opts.guidKey != null) {
		rowEl.attr("guid",newAddObj[this.opts.guidKey]);
	}

	if(this.opts.associativeArray == null || this.opts.associativeArray != true) {
		if(addIndex%2==1) {
			rowEl.removeClass("oddRow");
		} else {
			rowEl.addClass("oddRow");
		}
	}
	this.$el.find("." + this.opts.deleteClass).not(".delRowBtn").addClass("delRowBtn");





	if(this.opts.beforeNewRow != null) {
		this.opts.beforeNewRow(this, rowEl,newAddObj);
	}
	if(this.opts.beforeRow != null) {
		this.opts.beforeRow(this, rowEl,newAddObj);
	}
	
	if(this.opts.mapping != "flat") {
		for (var prop in this.opts.mapping) {
			if (this.opts.mapping.hasOwnProperty(prop)) {
				if(this.opts.mapping[prop]["type"] != null && this.opts.mapping[prop]["type"] == "subArrayTable") {
					var subOpts = owl.deepCopy(this.opts.mapping[prop]["opts"]);
					var elem = rowEl.find('.' + this.opts.mapping[prop]["el"]);
					if(subOpts.addBtnSeek != null) {
						subOpts["addBtn"] = subOpts.addBtnSeek(elem);
					}
					subOpts["dataSrc"] = this.opts.dataSrc[addIndex][prop];
					subOpts["subArrayTable"] = true;
					elem.ArrayTableView(subOpts);
					elem.addClass("subArrayTable").attr("keyprop", addIndex + "_" + prop);
				} else {
					var editEl = rowEl.find('.' + this.opts.mapping[prop]["el"]);
					var dispEl = rowEl.find('.' + this.opts.mapping[prop]["disp"]);
					dispEl.attr("prop", prop).addClass("fieldDisp");
					if (editEl.is("input")) {
						if (editEl.is("input[type='checkbox']")) {
							editEl.addClass("checkChangerEl");
							editEl.attr("prop", prop);
							editEl.data("obEdit", this);
							if (newAddObj[prop] == true) {
								editEl.attr("checked", "checked").change();
								dispEl.html("Yes");
							} else {
								editEl.removeAttr("checked").change();
								dispEl.html("No");
							}
						} else if (editEl.hasClass("dateTimeIn") || editEl.hasClass("datetimein")) {
							editEl.attr("prop", prop);
							if (newAddObj[prop] != null) {
								editEl.val(newAddObj[prop]).change();
								dispEl.html(fDate(newAddObj[prop]));
							}
							editEl.addClass("changerEl");
							editEl.addClass("keyChangerEl");
						} else if (editEl.is("input[type='radio']")) {
							editEl.addClass("radioChangerEl");
							editEl.attr("prop", prop);
							var selVal = newAddObj[prop];
							editEl.each(function() {
								if ($(this).attr("value") == selVal) {
									$(this).prop("checked", true);
								} else {
									$(this).prop("checked", false);
								}
							});
						} else {
							editEl.addClass("changerEl");
							if (newAddObj[prop] != null) {
								editEl.val(newAddObj[prop]).keyup();
							}
							editEl.addClass("keyChangerEl");
							editEl.attr("prop", prop);
						}
					} else if (editEl.is("textarea")) {
						if (newAddObj[prop] != null) {
							editEl.val(newAddObj[prop]).keyup();
							dispEl.html(newAddObj[prop]);
						} else {
							dispEl.html("");
						}
						editEl.addClass("keyChangerEl");
						editEl.attr("prop", prop);
						if (newAddObj[prop] != null) {
							editEl.val(newAddObj[prop]).change();
						} else {
							editEl.val("-1").change();
						}
						if (editEl.data("chosen") != null) {
							editEl.trigger("chosen:updated");
						}
						if (newAddObj[prop] != null) {
							dispEl.html(getSelectedOptionString(editEl));
						} else {
							dispEl.html("");
						}
					} else if (editEl.is("select")) {
						editEl.addClass("changerEl");
						editEl.attr("prop", prop);
					}
				}
			}
		}
	}
	
	if(this.opts.processRow != null) {
		this.opts.processRow(this, rowEl,newAddObj);
	}
	if(this.opts.applyChildState == true && newAddObj.state != null) {
		if(this.stateFuncts[newAddObj.state] != null) {
			this.stateFuncts[newAddObj.state](this, rowEl, newAddObj);
		}
	} else {
		if(this.stateFuncts[this.curState] != null) {
			this.stateFuncts[this.curState](this, rowEl, newAddObj);
		}
	}
	if(this.opts.addState != null && this.stateFuncts[this.opts.addState] != null) {
		this.stateFuncts[this.opts.addState](this, rowEl);
	}
	for (var prop in this.opts.mapping) {
		if (this.opts.mapping.hasOwnProperty(prop) && this.opts.mapping[prop]["chosen"] != null && this.opts.mapping[prop]["chosen"] == true) {
			if(this.opts.mapping[prop]["prefillWith"] != null) {
				rowEl.find("." + this.opts.mapping[prop]["el"]).html($(this.opts.mapping[prop]["prefillWith"]).html())
			}
			var chWidth = 120;
			if(this.opts.mapping[prop]["chosenWidth"] != null) {
				chWidth = this.opts.mapping[prop]["chosenWidth"];
			}
			rowEl.find("." + this.opts.mapping[prop]["el"]).val("-1").chosen({
				width:chWidth
			});
			rowEl.find("." + this.opts.mapping[prop]["el"]).removeClass("edit");
		}
	}
	rowEl.find(".chosen-container").addClass("edit");
	
	if(this.opts.afterNewRow != null) {
		this.opts.afterNewRow(this, rowEl,newAddObj);
	}

	if(this.opts.afterRow != null) {
		this.opts.afterRow(this, rowEl,newAddObj);
	}



	if(this.opts.rowChanged != null) {
		this.opts.rowChanged(this, rowEl,newAddObj);
	}
	//saveAllOpenCases();
  };

  $.fn.ArrayTableView = function(opts, callback) {
		$(this).addClass("arraytable");
		var arrayTableRep = new ArrayTableViewObject(this, opts, callback);
		if(callback != null) {
			callback(this, arrayTableRep);
		}
		$(this).data("ArrayTable", arrayTableRep);
		return arrayTableRep;
  };
  

})(jQuery, document, window);