/*
  Developed by LoveTech.io, Copyright 2016
*/

var ChakraGrid = {
	updateRate:333
};

$(document).ready(function() {
	if(ChakraGrid.updateRate != null) {
		window.setInterval(function(){
			$(".ChakraGridOn").each(function() {
				$(this).data("ChakraGrid").alignCells();
			}); 
		}, ChakraGrid.updateRate);
	}
});
function ChakraGridObject(el, opts) {
    this.$el  = $(el);
    this.opts = opts;
	if(this.opts == null) {
		  this.opts = {};
	}
	this.opts.sizing = "bootstrap";
	var sizingAttr = this.$el.attr("sizing");
	if(sizingAttr !== null && this.opts.sizing == null) {
	   this.opts.sizing = sizingAttr;
	}
	this.alignCells();
	var _ths = this;
	$(window).resize(function() {
		_ths.alignCells();
	});
  }

  
  ChakraGridObject.prototype.alignCells = function(opts) {
      if(opts == null) {
        opts = {};
      }
	    //this.$el.css("background-color", "green");
      //What is size class of parent
      var parentWidth = this.$el.width();
      var sizedAt = this.$el.attr("sizedAt");
      var alignHeights = true;
      var ah = this.$el.attr("alignHeights");
      if(ah == "false") {
          alignHeights = false;
      }
      var colEls = this.$el.find(".cCol:visible");
	  var colsVisAtr = this.$el.attr("colsVisible");
	  if(colsVisAtr == null) {
		colsVisAtr = 0;
	  } else {
		colsVisAtr = parseInt(colsVisAtr);
	  }
      if(opts.force == true || parentWidth != sizedAt || colsVisAtr != colEls.length) {
		  this.$el.attr("current_size", this.getCurSizeClass(parentWidth));
          //Resize each column div's width
          var _this = this;
          colEls.each(function() {
              var colEl = $(this);
              colEl.css("width", _this.getColWidth(colEl, parentWidth) + "%");
          });
          //Resize each rox x column div's height if specified by user  
          if(alignHeights) {
             colEls.height("auto");
             var indexIncr = 0;
             while(indexIncr < colEls.length) {
                 var groupStart = indexIncr;
                 var groupOffsetTop = $(colEls[indexIncr]).offset().top;
                 var groupEls = [$(colEls[groupStart])];
				 var fillWidthCols = [];
				 if($(colEls[groupStart]).is('[fillWidth="true"]')) {
					 fillWidthCols.push($(colEls[groupStart]));
				 }
                 var maxHeightInGroup = $(colEls[groupStart]).height();
                 for(var i = groupStart + 1; i < colEls.length; i++) {
                     var curOffset =  $(colEls[i]).offset().top;
                     if(curOffset > groupOffsetTop) {
                      break;
                     }
                     groupEls.push($(colEls[i]));
					 if($(colEls[i]).is('[fillWidth="true"]')) {
						 fillWidthCols.push($(colEls[i]));
					 }
                     var colHeight = $(colEls[i]).height(); 
                     if(colHeight > maxHeightInGroup) {
                         maxHeightInGroup = colHeight;
                     }
                 }                 
                 var childWidthSum = 0;
                 for(var i = 0; i < groupEls.length; i++) {
                    $(groupEls[i]).height(maxHeightInGroup);
                    var vAlignContent = $(groupEls[i]).children(".vcenter");
                    if(vAlignContent.length == 1) {
                        vAlignContent.css("margin-top", (maxHeightInGroup - vAlignContent.height()) / 2);
                    }
                    childWidthSum += $(groupEls[i]).outerWidth();
					//Odd even row styles?  Add odd even class
                    //$(groupEls[i]).css("background-color", "#" + randomColor);
                 }
                
				if(fillWidthCols.length > 0 && ((childWidthSum + 50) < parentWidth)) {
					var delta = (parentWidth - childWidthSum) / fillWidthCols.length;
					for(var i = 0; i < fillWidthCols.length; i++) {
						var curWidth = $(fillWidthCols[i]).width();
						$(fillWidthCols[i]).width(Math.floor(curWidth + delta) - 1);
					}
				}
				
                indexIncr += groupEls.length;
             }
           }
          this.$el.attr("sizedAt", parentWidth);
          this.$el.attr("colsVisible", colEls.length);
      } 
  };
                                                              
  ChakraGridObject.prototype.getCurSizeClass = function(parentWidth) {
       if(this.opts.sizing == null || this.opts.sizing == "bootstrap") {
            if(parentWidth >= 1200) {
                 return "xl";
            } else if(parentWidth >= 992) {
                 return "lg";
            } else if(parentWidth >= 768) {
                 return "md";
            } else if(parentWidth >= 544) {
                 return "sm";
            } else {
                 return "xs";
            }
       } else if(this.opts.sizing == "materialize") {
            if(parentWidth >= 992) {
                 return "lg";
            } else if(parentWidth >= 600) {
                 return "md";
            } else {
                 return "sm";
            }
       }
  };
  ChakraGridObject.prototype.getColWidth = function(colEl, parentWidth) {
       if(this.opts.sizing == null || this.opts.sizing == "bootstrap") {
            if(parentWidth >= 1200) {
                 return this.getWidthPerc(colEl, "xl");
            } else if(parentWidth >= 992) {
                 return this.getWidthPerc(colEl, "lg");
            } else if(parentWidth >= 768) {
                 return this.getWidthPerc(colEl, "md");
            } else if(parentWidth >= 544) {
                 return this.getWidthPerc(colEl, "sm");
            } else {
                 return this.getWidthPerc(colEl, "xs");
            }
       } else if(this.opts.sizing == "materialize") {
            if(parentWidth >= 992) {
                 return this.getWidthPerc(colEl, "lg");
            } else if(parentWidth >= 600) {
                 return this.getWidthPerc(colEl, "md");
            } else {
                 return this.getWidthPerc(colEl, "sm");
            }
       }
  };
  ChakraGridObject.prototype.getWidthPerc = function(colEl, size) {
    if(size == "xs") {
        var xs = colEl.attr("xs");
        if(xs != null) {
            return 100 * (parseInt(xs) / 12);
        }
    } else if(size == "sm") { 
        var sm = colEl.attr("sm");
        if(sm != null) {
            return 100 * (parseInt(sm) / 12);
        }
        var xs = colEl.attr("xs");
        if(xs != null) {
            return 100 * (parseInt(xs) / 12);
        }
    }  else if(size == "md") { 
        var md = colEl.attr("md");
        if(md != null) {
            return 100 * (parseInt(md) / 12);
        }                       
        var sm = colEl.attr("sm");
        if(sm != null) {
            return 100 * (parseInt(sm) / 12);
        }
        var xs = colEl.attr("xs");
        if(xs != null) {
            return 100 * (parseInt(xs) / 12);
        }
    }  else if(size == "lg") {   
        var lg = colEl.attr("lg");
        if(lg != null) {
            return 100 * (parseInt(lg) / 12);
        }    
        var md = colEl.attr("md");
        if(md != null) {
            return 100 * (parseInt(md) / 12);
        }                       
        var sm = colEl.attr("sm");
        if(sm != null) {
            return 100 * (parseInt(sm) / 12);
        }
        var xs = colEl.attr("xs");
        if(xs != null) {
            return 100 * (parseInt(xs) / 12);
        }
    } else if(size == "xl") {    
        var xl = colEl.attr("xl");
        if(xl != null) {
            return 100 * (parseInt(xl) / 12);
        }  
        var lg = colEl.attr("lg");
        if(lg != null) {
            return 100 * (parseInt(lg) / 12);
        }    
        var md = colEl.attr("md");
        if(md != null) {
            return 100 * (parseInt(md) / 12);
        }                       
        var sm = colEl.attr("sm");
        if(sm != null) {
            return 100 * (parseInt(sm) / 12);
        }
        var xs = colEl.attr("xs");
        if(xs != null) {
            return 100 * (parseInt(xs) / 12);
        }
    }
    return 100;
  };

  $.fn.ChakraGrid = function(opts) {
	  if($(this).length == 1) {
        var object = new ChakraGridObject(this, opts);
      	$(this).addClass("ChakraGridOn").data("ChakraGrid", object);
        return object;
     } else {
        $(this).each(function() {
           var object = new ChakraGridObject(this, opts);
      	   $(this).addClass("ChakraGridOn").data("ChakraGrid", object);
       });
     }     
  };