/*
  Developed by LoveTech.io, Copyright 2016
  Released Under the MOT License - Free to Use and Distribute w/ This Comment
  May All Beings Be Happy and Free
*/
var badElToHide;
$(document).ready(function() {
	$(document).on("input", '.keyupTrg', function() {
		if(!$(this).hasClass("smartSelect")) {
			var objEditObj = $(this).data("obEdit");
			if(objEditObj != null && objEditObj.listening == true) {
				var newVal = $(this).val();
				var prop = $(this).attr("prop");
				if(objEditObj.changeTimeouts.hasOwnProperty(prop)) {
					window.clearTimeout(objEditObj.changeTimeouts[prop]);
				}
				var inputEl = $(this);
				var finished = function() {
					if(inputEl.hasClass("remainNumeric")) {
						var numValNum = parseFloat(newVal);
						if(isNaN(numValNum)) {
							inputEl.addClass("badNumber");
							badElToHide = inputEl;
							window.setTimeout(function() {
								if(badElToHide != null) {
									badElToHide.removeClass("badNumber");
									badElToHide = null;
								}
							}, 1000);
							return -1;
						} else {
							$(this).removeClass("badNumber");
						}
						objEditObj.updateProperty(prop, numValNum);
						return;
					}
					objEditObj.updateProperty(prop, newVal);
				 };
				if(objEditObj.opts.changeRate == false) {
					finished();
				} else {
					objEditObj.changeTimeouts[prop] = window.setTimeout(finished, objEditObj.opts.changeRate);
				}
				
				
				
			}
		}
	});
	$(document).bind("change", ".retainDateTrg", function(e, props) {
		if(props != null && props.elem != null && props.newISO != null) {
			var objEditObj = props.elem.closest(".OEA").data("OEA");
			if(objEditObj != null && objEditObj.listening == true) {
				objEditObj.updateProperty(props.elem.attr("prop"), props.newISO);
			}
		}
	});
	$(document).bind("change", ".retainDateTimeTrg", function(e, props) {
		if(props != null && props.elem != null && props.newISO != null) {
			var objEditObj = props.elem.closest(".OEA").data("OEA");
			if(objEditObj != null && objEditObj.listening == true) {
				objEditObj.updateProperty(props.elem.attr("prop"), props.newISO);
			}
		}
	});
	$(document).on("change", '.dateChangeTrg', function() {
		var objEditObj = $(this).data("obEdit");
		if(objEditObj != null && objEditObj.listening == true) {
			objEditObj.updateProperty($(this).attr("prop"), $(this).val());
		}
	});
	$(document).on("change", '.pickDateChangeTrg', function() {
		var objEditObj = $(this).data("obEdit");
		if(objEditObj != null && objEditObj.listening == true) {
			objEditObj.updateProperty($(this).attr("prop"), $(this).data("pickadate").get('select', 'yyyy-mm-dd'));
		}
	});
	$(document).on("change", '.checkChangeTrigger', function() {
		var objEditObj = $(this).data("obEdit");
		if(objEditObj != null && objEditObj.listening == true) {
			objEditObj.updateProperty($(this).attr("prop"), $(this).is(":checked"));
		}
	});
	$(document).on("change", '.radioChangeTrigger', function() {
		var objEditObj = $(this).data("obEdit");
		if(objEditObj != null && objEditObj.listening == true) {
			var radioName = $(this).attr("name");
			objEditObj.updateProperty($(this).attr("prop"), $('input[type="radio"][name="' + radioName + '"]').filter(":checked").attr("val"));
		}
	});
	$(document).on("change", '.selTrg', function() {
		var objEditObj = $(this).data("obEdit");
		var newVal = $(this).val();
		if(objEditObj != null && objEditObj.listening == true) {
			objEditObj.updateProperty($(this).attr("prop"), newVal);
		}
	});
});
(function($, doc, win) {
  "use strict";
 
 function ObjectEditAdaptorObj(el, opts, callback) {
    this.$el  = $(el);
    this.opts = opts;
    this.callback = callback;
	this.curState = "display";
	this.listening = false;
	this.doneInit = false;
	this.saveTimeouts = {};
	this.months = ["", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	this.stateFuncts = {
		"edit":function(objEditAd, el) {
			el.find(".display").hide();
			el.find(".edit").show();
			//el.find(".checkChangeTrigger").removeAttr("disabled");
			//el.find(".checkChangeTrigger").prop("disabled", false);
		},
		"display":function(objEditAd, el) {
			el.find(".display").show();
			el.find(".edit").hide();
			//el.find(".checkChangeTrigger").attr("disabled","disabled");
			//el.find(".checkChangeTrigger").prop("disabled", true);
		}
	};
	//this.$el.find(".selTrg").removeClass("selTrg");
	if(this.opts.states != null) {
		for (var key in this.opts.states) {
			if (this.opts.states.hasOwnProperty(key)) {
				this.stateFuncts[key] = this.opts.states[key];
			}
		}
	}
	if(opts.dataSrc == null) {
		this.opts.dataSrc = {};
	} else if(this.opts.defaultObj != null) {
		for(prop in this.opts.defaultObj) {
			if(this.opts.defaultObj.hasOwnProperty(prop)) {
				if(this.opts.dataSrc[prop] == null) {
					this.opts.dataSrc[prop] = owl.deepCopy(this.opts.defaultObj[prop]);
				}
			}
		}
	}
	if(opts.startState !=null) {
		this.curState = opts.startState;
	}
	if(this.opts.changeRate == null) {
		this.opts.changeRate = 333;
	}
	if(this.opts.saveRate == null) {
		this.opts.saveRate = 500;
	}
	this.changeTimeouts = {};
	for (var prop in this.opts.mapping) {
		if (this.opts.mapping.hasOwnProperty(prop)) {
			var editEl = $([]);
			if(this.opts.mapping[prop]["el"] != null) {
				editEl = this.opts.mapping[prop]["el"];
			}
			var dispEl = $([]);
			if(this.opts.mapping[prop]["disp"] != null) {
				dispEl = this.opts.mapping[prop]["disp"];
			}
			var type = "default";
			if(this.opts.mapping[prop]["type"] != null) {
				type = this.opts.mapping[prop]["type"];
			}
			
			if(editEl.is("input[type='checkbox']")) {
				if(this.opts.dataSrc[prop] == true) {
					editEl.prop("checked", true);
					
				} else {
					editEl.prop("checked", false);
				}				
			} else if(editEl.is("input[type='radio']")) {
				editEl.prop("checked", false);
				editEl.filter('[val="' + this.opts.dataSrc[prop] + '"]').prop("checked", true);
			} else {
				if(editEl.hasClass("smartSelect")) {
					Cascade.smartSet({
						"val":this.opts.dataSrc[prop],
						"el":editEl,
						"dispEl":dispEl
					});
				} else if(type == "date") {
					dispEl.html(this.fDate(new Date(this.opts.dataSrc[prop])));
				} else if(type == "datetime") {
					dispEl.html(this.fDateTime(new Date(this.opts.dataSrc[prop])));
				} else if(editEl.hasClass("picker__input")) {
					var dateFormat = 'yyyy-mm-dd';
					if(this.opts.mapping[prop]["dateFormat"] != null) {
						dateFormat = this.opts.mapping[prop]["dateFormat"];
					}
					var dateObj = new Date(this.opts.dataSrc[prop]);
					if(isNaN(dateObj)) {
						editEl.data("pickadate").set('clear');
						dispEl.html("");
					} else {
						editEl.data("pickadate").set('select', this.opts.dataSrc[prop], { format: dateFormat });
						dispEl.html(editEl.data("pickadate").get('value'));
					}
				} else {
					//Standard
					editEl.val(this.opts.dataSrc[prop]);
					dispEl.html(this.lineBreaks(this.opts.dataSrc[prop]));
				}
			}
			if(editEl.data("chosen") != null) {
				editEl.trigger("chosen:updated");
			}
			if(editEl.is("input")) {
				if(editEl.is("input[type='checkbox']")) {
					editEl.attr("prop", prop);
					editEl.data("obEdit", this);
					editEl.addClass("checkChangeTrigger");
				} else if(editEl.is("input[type='radio']")) {
					editEl.attr("prop", prop);
					editEl.data("obEdit", this);
					editEl.addClass("radioChangeTrigger");
					if(this.opts.dataSrc[prop] == null) {
						this.opts.dataSrc[prop] = editEl.filter(":checked").val();
					}
				} else if(editEl.hasClass("hasDatepicker") || editEl.hasClass("timePicker")) {
					editEl.attr("prop", prop);
					editEl.data("obEdit", this);
					editEl.addClass("dateChangeTrg");
				} else if(editEl.hasClass("picker__input")) {
					editEl.attr("prop", prop);
					editEl.data("obEdit", this);
					editEl.addClass("pickDateChangeTrg");
				} else {
					editEl.attr("prop", prop);
					editEl.data("obEdit", this);
					editEl.addClass("keyupTrg");
					if(this.opts.dataSrc[prop] == null) {
						this.opts.dataSrc[prop] = "";
					}
					if(type == "number") {
						editEl.addClass("remainNumeric");
						editEl.attr("type", "number");
					}
					//editEl.addClass("dateChangeTrg");
				}
				if(this.opts.dataSrc[prop] == null) {
					this.opts.dataSrc[prop] = "";
				}
				if(this.opts.mapping[prop]["disp"] != null) {
					if(editEl.hasClass("hasDatepicker")) {
						this.opts.mapping[prop]["disp"].html(ObjectEditAdaptor(this.opts.dataSrc[prop]));
					} else if(editEl.hasClass("picker__input")) {
						//editEl.set('select', '2016-04-20', { format: 'yyyy-mm-dd' });
						this.opts.mapping[prop]["disp"].html(editEl.get("value"));
					} else if(editEl.is("input[type='checkbox']")) {
						if(this.opts.dataSrc[prop] == true) {
							if(this.opts.mapping[prop]["disp"] == null) {
								editEl.prop("checked", true);
							} else {
								var txtVal = "Yes";
								if(this.opts.mapping[prop]["yTxt"] != null) {
									txtVal = this.opts.mapping[prop]["yTxt"];
								}
								this.opts.mapping[prop]["disp"].html(this.lineBreaks(txtVal));
							}
							
						} else {
							if(this.opts.mapping[prop]["disp"] == null) {
								editEl.prop("checked", false);
							} else {
								var txtVal = "No";
								if(this.opts.mapping[prop]["nTxt"] != null) {
									txtVal = this.opts.mapping[prop]["nTxt"];
								}
								this.opts.mapping[prop]["disp"].html(this.lineBreaks(txtVal));
							}
						}
					} else {
						this.opts.mapping[prop]["disp"].html(this.lineBreaks(this.opts.dataSrc[prop]));
					}
				}
			} else if(editEl.is("textarea")) {
				editEl.attr("prop", prop);
				editEl.data("obEdit", this);
				if(this.opts.dataSrc[prop] == null) {
					this.opts.dataSrc[prop] = "";
				}
				if(this.opts.mapping[prop]["disp"] != null) {
					this.opts.mapping[prop]["disp"].html(this.lineBreaks(this.opts.dataSrc[prop]));
				}
				editEl.addClass("keyupTrg");
				if(editEl.hasClass("materialize-textarea")) {
					editEl.trigger('autoresize');
				}
			} else if(editEl.is("select")) {
				//console.log("select el");
				//console.log(editEl);
				editEl.attr("prop", prop);
				editEl.data("obEdit", this);
				editEl.data("prev", this.opts.dataSrc[prop]);
				editEl.addClass("selTrg");
				var dispVal = "";
				if(editEl.attr("multiple") == "multiple") {
					var checkedStrs = [];
					if(this.opts.dataSrc[prop] == null) {
						this.opts.dataSrc[prop] = [];
					}
					var mulVal = this.opts.dataSrc[prop];
					var startWidth = 220;
					if(editEl.attr("sWidth") != null) {
						startWidth = parseInt();
					} 
					editEl.val(mulVal).change();
					if(editEl.data().hasOwnProperty("multipleSelect")) {
						editEl.multipleSelect();
					}
					editEl.removeClass("edit");
					editEl.next(".ms-parent").addClass("edit");
					(editEl.find("option:selected")).each(function() {
						checkedStrs.push($(this).html());
					});
					dispVal = checkedStrs.join(", ");
				} else {
					if(editEl.hasClass("initialized") && editEl.data("selectId") != null) {
						editEl.material_select();
					}
					if(editEl.hasClass("chosenMultiAbstract")) {
						if(this.opts.dataSrc[prop].constructor !== Array) {
							this.opts.dataSrc[prop] = [this.opts.dataSrc[prop]];
						}
						if(editEl.find("option[value='" + this.opts.dataSrc[prop][0] + "']").length > 0) {
							dispVal = editEl.find("option[value='" + this.opts.dataSrc[prop][0] + "']").html();
						}
					} else {
						if(editEl.find("option[value='" + this.opts.dataSrc[prop] + "']").length > 0) {
							dispVal = editEl.find("option[value='" + this.opts.dataSrc[prop] + "']").html();
						}
					}
				}
				if(this.opts.dataSrc[prop] == null) {
					this.opts.dataSrc[prop] = "-1";
				}
				if(this.opts.mapping[prop]["disp"] != null) {
					if(this.opts.dataSrc[prop] == "-1") {
						this.opts.mapping[prop]["disp"].html("");
					} else {
						this.opts.mapping[prop]["disp"].html(this.lineBreaks(dispVal));
					}
				}
			} else if(type == "date") {
				editEl.addClass("remainDate");
				editEl.attr("prop", prop);
				editEl.attr("type", "date");
				editEl.MaintainDate({
					"dataSrc":this.opts.dataSrc[prop],
					"addClasses":"retainDateTrg",
					"dataChanged": function() {
						
					}
				});
			} else if(type == "datetime") {
				editEl.addClass("remainDateTime");
				editEl.attr("type", "datetime");
				editEl.attr("prop", prop);
				var materializeFlag = false;
				var materializeLabel = "";
				if(this.opts.mapping[prop].hasOwnProperty("materialize")) {
					materializeFlag = this.opts.mapping[prop].materialize;
				}
				if(this.opts.mapping[prop].hasOwnProperty("materializeLabel")) {
					materializeLabel = this.opts.mapping[prop].materializeLabel;
				}
				editEl.MaintainDateTime({
					"dataSrc":this.opts.dataSrc[prop],
					"addClasses":"retainDateTimeTrg",
					"materialize":materializeFlag,
					"materializeLabel":materializeLabel,
					"dataChanged": function() {
						
					}
				});
			}
		}
	}
	if(this.stateFuncts[this.curState] != null) {
		this.stateFuncts[this.curState](this, $(el));
	}
	if(this.opts.onRender != null) {
		this.opts.onRender();
	}
	if(this.opts.onChange != null) {
		this.opts.onChange();
	}
	if(Materialize != null) {
		Materialize.updateTextFields();
	}
	this.listening = true;
  }
  ObjectEditAdaptorObj.prototype.stopListening = function() {
	this.listening = false;
  };
  ObjectEditAdaptorObj.prototype.fDate = function(date1) {
	var year = date1.getFullYear();
    var month = this.months[date1.getMonth() + 1];
    var h = date1.getHours();
    var m = date1.getMinutes();
    var date = date1.getDate();
    var ampm = "AM";
    if(m < 10) {
        m = "0" + m;
    }
    return month + " " + date + ", " + year;
  };
  ObjectEditAdaptorObj.prototype.slashDate = function(date1) {
	var year = date1.getFullYear();
    var date = date1.getDate();
    var month = (date1.getMonth() + 1);
    if(date < 10) {
        date = "0" + date;
    }
    if(month < 10) {
        month = "0" + month;
    }
    return month + "/" + date + "/" + year;
  };
  ObjectEditAdaptorObj.prototype.fDateTime = function(date1) {
    var year = date1.getFullYear();
    var month = this.months[date1.getMonth() + 1];
    var h = date1.getHours();
    var date = date1.getDate();
    var m = date1.getMinutes();
    var ampm = "AM";
    if(m < 10) {
        m = "0" + m;
    }
    if(h > 12) {
        h = h - 12;
        var ampm = "PM";
    }
    return month + " " + date + ", " + year + " " + h + ":" + m + " " + ampm;
  };
  ObjectEditAdaptorObj.prototype.slashDateTime = function(date1) {
    var year = date1.getFullYear();
    var month = date1.getMonth() + 1;
	if(month < 10) {
		month = "0" + month;
	}
    var h = date1.getHours();
    var date = date1.getDate();
    var m = date1.getMinutes();
    var ampm = "AM";
    if(m < 10) {
        m = "0" + m;
    }
    if(h > 12) {
        h = h - 12;
        var ampm = "PM";
    }
    return month + "/" + date + "/" + year + " " + h + ":" + m + " " + ampm;
  };
  ObjectEditAdaptorObj.prototype.lineBreaks = function(str) {
	if(str == null) {
		return "";
	}
	if(typeof str == "string") {
		return str.replace(/\n/g, "<br />");
	}
	return str;
  };
  ObjectEditAdaptorObj.prototype.updateProperty = function(prop, newVal) {
	if (this.opts.mapping.hasOwnProperty(prop)) {
		var editEl = this.opts.mapping[prop]["el"];
		var changeDefData = {
			"prop":prop,
			"newVal":newVal
		};
		if(editEl.is("select")) {
			var prevVal = editEl.data("prev");
			editEl.data("prev", newVal);
			if(prevVal != null) {
				changeDefData.prevVal = prevVal;
			}
		}
		this.opts.dataSrc[prop] = newVal;
		if(this.opts.dataChanged != null) {
			this.opts.dataChanged(this, changeDefData, this.opts.dataSrc);
		}
		if(this.saveTimeouts.hasOwnProperty(prop)) {
			window.clearTimeout(this.saveTimeouts[prop]);
			delete this.saveTimeouts[prop];
		}
		if(this.opts.save != null) {
			var _ths = this;
			this.saveTimeouts[prop] = window.setTimeout(function() {
				_ths.opts.save(this, {"prop":prop, "newVal":newVal}, _ths.opts.dataSrc);
			}, this.opts.saveRate);
		}

		if(editEl.hasClass("hasDatepicker")) {
			newVal = this.fDate(newVal);
		} else if(editEl.hasClass("remainDate")) {
			newVal = this.fDate(new Date(newVal));
		} else if(editEl.hasClass("remainDateTime")) {
			newVal = this.fDateTime(new Date(newVal));
		} else if(editEl.is("input[type='checkbox']")) {
			if(this.opts.dataSrc[prop] == true) {
				newVal = "Yes";
				if(this.opts.mapping[prop]["yTxt"] != null) {
					newVal = this.opts.mapping[prop]["yTxt"];
				}
			} else {
				newVal = "No";
				if(this.opts.mapping[prop]["nTxt"] != null) {
					newVal = this.opts.mapping[prop]["nTxt"];
				}
			}
		}
		if(editEl.is("select")) {
			var dispVal = "";
			if(editEl.attr("multiple") == "multiple") {
				var checkedStrs = [];
				(editEl.find("option:selected")).each(function() {
					checkedStrs.push($(this).html());
				});
				dispVal = checkedStrs.join(", ");
			} else {
				if(editEl.hasClass("chosenMultiAbstract")) {
					if(this.opts.dataSrc[prop].constructor !== Array) {
						this.opts.dataSrc[prop] = [this.opts.dataSrc[prop]];
					}
					dispVal = editEl.find("option[value='" + this.opts.dataSrc[prop][0] + "']").html();
				} else {
					dispVal = editEl.find("option[value='" + this.opts.dataSrc[prop] + "']").html();
				}
			}
			if(this.opts.mapping[prop]["disp"] != null) {
				if(this.opts.mapping[prop].dispRule == null) {
					if(this.opts.dataSrc[prop] == "-1" || this.opts.dataSrc[prop] == null) {
						this.opts.mapping[prop]["disp"].html("");
					} else {
						this.opts.mapping[prop]["disp"].html(this.lineBreaks(dispVal));
					}
				} else {
					this.opts.mapping[prop].dispRule(this.opts.mapping[prop].disp, newVal);
				}
			}
		} else {
			if(this.opts.mapping[prop].disp != null) {
				if(this.opts.mapping[prop].dispRule == null) {
					this.opts.mapping[prop].disp.html(this.lineBreaks(newVal));
				} else {
					this.opts.mapping[prop].dispRule(this.opts.mapping[prop].disp, newVal);
				}
			}
		}
		if(this.opts.mapping[prop]["onChange"] != null) {
			this.opts.mapping[prop]["onChange"]();
		}
	}
	//saveAllOpenCases();
  };

  $.fn.ObjectEditAdaptor = function(opts, callback) {
    var objEd = new ObjectEditAdaptorObj(this, opts, callback);
	$(this).addClass("OEA");
	$(this).data("OEA", objEd);
	return $(this);
  };
  

})(jQuery, document, window);