/*
  Developed by LoveTech.io, Copyright 2016
*/

var stackAt = {
	updateRate:330
};
$(document).ready(function() {
	stackIfNeeded();
	$(window).resize(stackIfNeeded);
	window.setInterval(stackIfNeeded, stackAt.updateRate);
});

function stackIfNeeded() {
	$('.stackAt').each(function() {
		var lastWidth = $(this).attr("lastWid");
		if(lastWidth != null) {
			lastWidth = parseInt(lastWidth);
		}
		var newWidth = 0;
		if($(this).attr("useScreenWidth") == "true") {
			newWidth = $(window).width();	
		} else {
			newWidth = $(this).width();
		}
		if(lastWidth != newWidth) {
			$(this).attr("lastWid", newWidth);
			var breakpoint = $(this).attr("stackAt");
			if(breakpoint == null) {
				var classes = this.classList;
				for(var i = 0; i < classes.length; i++) {
					if(classes[i].indexOf("sa-") == 0) {
						breakpoint = parseInt(classes[i].substring(3));
						$(this).attr("stackAt", breakpoint);
						break;
					}
				}
				var splitEls = $(this).find(".splitEl");
				for(var i = 0; i < splitEls.length; i++) {
					var seClasses = splitEls[i].classList;
					for(var j = 0; j < seClasses.length; j++) {
						if(seClasses[j].indexOf("ci-") == 0) {
							var ci = parseInt(seClasses[j].substring(3));
							$(splitEls[i]).attr("column-index", ci);
						}
						if(seClasses[j].indexOf("fw-") == 0) {
							var fw = parseInt(seClasses[j].substring(3));
							$(splitEls[i]).attr("fixed-width", fw);
						} else if(seClasses[j].indexOf("rw-") == 0) {
							var rw = parseInt(seClasses[j].substring(3));
							$(splitEls[i]).attr("remainder-width", rw);
						}
					}
				}
			}
			if(breakpoint != null) {
				breakpoint = parseInt(breakpoint);
				$(this).children(".splitEl").height("auto");
				var maxChildHeight = 0;
				if(!isNaN(breakpoint) && newWidth <= breakpoint) {
					if(!$(this).hasClass("stackedNow")) {
						$(this).addClass("stackedNow");
						$(this).children(".splitEl[fixed-width]").css("position", "").css("top", "").css("left", "");
						$(this).children(".splitEl[remainder-width]").css("width", "").css("position", "").css("top", "").css("left", "");
					}
				} else {
					$(this).removeClass("stackedNow");
					var fixedWidthEls = $(this).children(".splitEl[fixed-width]");
					var remainderWidthEls = $(this).children(".splitEl[remainder-width]");
					var parentWidth = $(this).width();
					if(fixedWidthEls.length > 0 || remainderWidthEls.length > 0) {
						var numColumnSpecified = $(this).children(".splitEl[column-index]").length;
						var maxHeight = 0;
						fixedWidthEls.height("auto");
						remainderWidthEls.height("auto");
						var fixedSum = 0;
						fixedWidthEls.each(function() {
							var elWidth = parseInt($(this).attr("fixed-width"));
							fixedSum += elWidth;
							maxHeight = incHeightIfTaller(maxHeight, $(this));
						});
						var widthOfPerc = Math.floor(100.0 * (parentWidth - fixedSum - 0.05)) / 10000.0;
						var widthInc = 0;
						if(numColumnSpecified > 0) {
							//Affix first column
							var firstCol = $(this).children(".splitEl[column-index='1']");
							var remainWidthAttr = firstCol.attr("remainder-width");
							maxHeight = incHeightIfTaller(maxHeight, firstCol);
							if(remainWidthAttr != null) {
								var percOfRemainder = parseFloat(remainWidthAttr);
								var colWidth = Math.floor(widthOfPerc * percOfRemainder - 0.05);
								firstCol.outerWidth(colWidth);
								widthInc += colWidth;
							}
							var fixedWidthAttr = firstCol.attr("fixed-width");
							if(fixedWidthAttr != null) {
								var colWidth = parseFloat(fixedWidthAttr);
								firstCol.outerWidth(colWidth);
								widthInc += colWidth;
							}
							//Position absolute others
							for(var i = 2; i <= numColumnSpecified; i++) {
								var curCol = $(this).children(".splitEl[column-index='" + i + "']");
								var remainWidthAttr = curCol.attr("remainder-width");
								maxHeight = incHeightIfTaller(maxHeight, curCol);
								if(remainWidthAttr != null) {
									var percOfRemainder = parseFloat(remainWidthAttr);
									var colWidth = Math.floor(widthOfPerc * percOfRemainder);
									curCol.outerWidth(Math.min(colWidth, parentWidth - widthInc));
									curCol.css("position", "absolute").css("top", "0px").css("left", widthInc + "px");
									widthInc += colWidth;
								}
								var fixedWidthAttr = curCol.attr("fixed-width");
								if(fixedWidthAttr != null) {
									var colWidth = parseFloat(fixedWidthAttr);
									curCol.outerWidth(Math.min(colWidth, parentWidth - widthInc));
									curCol.css("position", "absolute").css("top", "0px").css("left", widthInc + "px");
									widthInc += colWidth;
								}
							}
						} else {
							fixedWidthEls.add(remainderWidthEls).css("float", "left");
							remainderWidthEls.each(function() {
								var percOfRemainder = parseFloat($(this).attr("remainder-width"));
								var colWidth = Math.floor(widthOfPerc * percOfRemainder);
								$(this).outerWidth(Math.min(colWidth, parentWidth - widthInc));
								widthInc += colWidth;
								maxHeight = incHeightIfTaller(maxHeight, $(this));
								
							});
							fixedWidthEls.each(function() {
								var colWidth = parseInt($(this).attr("fixed-width"));
								$(this).outerWidth(Math.min(colWidth, parentWidth - widthInc));
								widthInc += colWidth;
							});
						}
					}
				}
			}
			var fillHeights = $(this).attr("fillHeights");
			if(fillHeights == "true") {
				$(this).children(".splitEl").height(maxHeight);
			}
			var parentChakraGrid = $(this).closest(".ChakraGridOn");
			if(parentChakraGrid.length > 0) {
				var cGrid = parentChakraGrid.data("ChakraGrid");
				cGrid.alignCells({
					force:true
				});
			}
			var newWidthAft = 0;
			if($(this).attr("useScreenWidth") == "true") {
				newWidthAft = $(window).width();	
			} else {
				newWidthAft = $(this).width();
			}
			if(newWidthAft != newWidth) {
				$(this).attr("lastWid", newWidthAft);
			}
		}
	});
	
}
function incHeightIfTaller(maxHeight, el) {
	var tHeight = el.height();
	if(tHeight > maxHeight) {
		return tHeight;
	}
	return maxHeight;
}